/*
 * This File is one of the examples from Java Object Oriented Programming
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */

package overridingObjectClass;

import java.util.Objects;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */

public class NewClass {
    String content = "Hello World!";
    
    @Override
    public String toString(){
        return content;        
    }
    
    @Override
    public boolean equals(Object o){
        if (o instanceof NewClass){
        return ((NewClass) o).content.equals(this.content);//Cast o as a NewClass
        } else {//we are not comparing apples with apples so they can't be the same.
            return false;
        }
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + Objects.hashCode(this.content);
        return hash;
    }
    
    
}
